<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents an Operation resource.
 * Google Compute Engine has three Operation resources:
 * * [Global](/compute/docs/reference/rest/{$api_version}/globalOperations) * [Regional](/compute/docs/reference/rest/{$api_version}/regionOperations) * [Zonal](https://cloud.google.com/compute/docs/reference/rest/{$api_version}/zoneOperations)
 * You can use an operation resource to manage asynchronous API requests. For more information, read Handling API responses.
 * Operations can be global, regional or zonal.
 * - For global operations, use the `globalOperations` resource.
 * - For regional operations, use the `regionOperations` resource.
 * - For zonal operations, use the `zonalOperations` resource.
 * For more information, read  Global, Regional, and Zonal Resources. (== resource_for {$api_version}.globalOperations ==) (== resource_for {$api_version}.regionOperations ==) (== resource_for {$api_version}.zoneOperations ==)
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.Operation</code>
 */
class Operation extends \Google\Protobuf\Internal\Message
{
    /**
     * [Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.
     *
     * Generated from protobuf field <code>string client_operation_id = 28804839;</code>
     */
    private $client_operation_id = '';
    /**
     * [Deprecated] This field is deprecated.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     */
    private $creation_timestamp = '';
    /**
     * [Output Only] A textual description of the operation, which is set when the operation is created.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     */
    private $description = '';
    /**
     * [Output Only] The time that this operation was completed. This value is in RFC3339 text format.
     *
     * Generated from protobuf field <code>string end_time = 114938801;</code>
     */
    private $end_time = '';
    /**
     * [Output Only] If errors are generated during processing of the operation, this field will be populated.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Error error = 96784904;</code>
     */
    private $error = null;
    /**
     * [Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as `NOT FOUND`.
     *
     * Generated from protobuf field <code>string http_error_message = 202521945;</code>
     */
    private $http_error_message = '';
    /**
     * [Output Only] If the operation fails, this field contains the HTTP error status code that was returned. For example, a `404` means the resource was not found.
     *
     * Generated from protobuf field <code>int32 http_error_status_code = 43909740;</code>
     */
    private $http_error_status_code = 0;
    /**
     * [Output Only] The unique identifier for the operation. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     */
    private $id = '';
    /**
     * [Output Only] The time that this operation was requested. This value is in RFC3339 text format.
     *
     * Generated from protobuf field <code>string insert_time = 165287059;</code>
     */
    private $insert_time = '';
    /**
     * [Output Only] Type of the resource. Always `compute#operation` for Operation resources.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     */
    private $kind = '';
    /**
     * [Output Only] Name of the operation.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     */
    private $name = '';
    /**
     * [Output Only] The type of operation, such as `insert`, `update`, or `delete`, and so on.
     *
     * Generated from protobuf field <code>string operation_type = 177650450;</code>
     */
    private $operation_type = '';
    /**
     * [Output Only] An optional progress indicator that ranges from 0 to 100. There is no requirement that this be linear or support any granularity of operations. This should not be used to guess when the operation will be complete. This number should monotonically increase as the operation progresses.
     *
     * Generated from protobuf field <code>int32 progress = 72663597;</code>
     */
    private $progress = 0;
    /**
     * [Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     */
    private $region = '';
    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     */
    private $self_link = '';
    /**
     * [Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.
     *
     * Generated from protobuf field <code>string start_time = 37467274;</code>
     */
    private $start_time = '';
    /**
     * [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Operation.Status status = 181260274;</code>
     */
    private $status = 0;
    /**
     * [Output Only] An optional textual description of the current status of the operation.
     *
     * Generated from protobuf field <code>string status_message = 28992698;</code>
     */
    private $status_message = '';
    /**
     * [Output Only] The unique target ID, which identifies a specific incarnation of the target resource.
     *
     * Generated from protobuf field <code>string target_id = 258165385;</code>
     */
    private $target_id = '';
    /**
     * [Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the persistent disk that the snapshot was created from.
     *
     * Generated from protobuf field <code>string target_link = 62671336;</code>
     */
    private $target_link = '';
    /**
     * [Output Only] User who requested the operation, for example: `user&#64;example.com`.
     *
     * Generated from protobuf field <code>string user = 3599307;</code>
     */
    private $user = '';
    /**
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.Warnings warnings = 229655639;</code>
     */
    private $warnings;
    /**
     * [Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.
     *
     * Generated from protobuf field <code>string zone = 3744684;</code>
     */
    private $zone = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $client_operation_id
     *           [Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.
     *     @type string $creation_timestamp
     *           [Deprecated] This field is deprecated.
     *     @type string $description
     *           [Output Only] A textual description of the operation, which is set when the operation is created.
     *     @type string $end_time
     *           [Output Only] The time that this operation was completed. This value is in RFC3339 text format.
     *     @type \Google\Cloud\Compute\V1\Error $error
     *           [Output Only] If errors are generated during processing of the operation, this field will be populated.
     *     @type string $http_error_message
     *           [Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as `NOT FOUND`.
     *     @type int $http_error_status_code
     *           [Output Only] If the operation fails, this field contains the HTTP error status code that was returned. For example, a `404` means the resource was not found.
     *     @type string $id
     *           [Output Only] The unique identifier for the operation. This identifier is defined by the server.
     *     @type string $insert_time
     *           [Output Only] The time that this operation was requested. This value is in RFC3339 text format.
     *     @type string $kind
     *           [Output Only] Type of the resource. Always `compute#operation` for Operation resources.
     *     @type string $name
     *           [Output Only] Name of the operation.
     *     @type string $operation_type
     *           [Output Only] The type of operation, such as `insert`, `update`, or `delete`, and so on.
     *     @type int $progress
     *           [Output Only] An optional progress indicator that ranges from 0 to 100. There is no requirement that this be linear or support any granularity of operations. This should not be used to guess when the operation will be complete. This number should monotonically increase as the operation progresses.
     *     @type string $region
     *           [Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.
     *     @type string $self_link
     *           [Output Only] Server-defined URL for the resource.
     *     @type string $start_time
     *           [Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.
     *     @type int $status
     *           [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
     *     @type string $status_message
     *           [Output Only] An optional textual description of the current status of the operation.
     *     @type string $target_id
     *           [Output Only] The unique target ID, which identifies a specific incarnation of the target resource.
     *     @type string $target_link
     *           [Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the persistent disk that the snapshot was created from.
     *     @type string $user
     *           [Output Only] User who requested the operation, for example: `user&#64;example.com`.
     *     @type \Google\Cloud\Compute\V1\Warnings[]|\Google\Protobuf\Internal\RepeatedField $warnings
     *           [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     *     @type string $zone
     *           [Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * [Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.
     *
     * Generated from protobuf field <code>string client_operation_id = 28804839;</code>
     * @return string
     */
    public function getClientOperationId()
    {
        return $this->client_operation_id;
    }

    /**
     * [Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.
     *
     * Generated from protobuf field <code>string client_operation_id = 28804839;</code>
     * @param string $var
     * @return $this
     */
    public function setClientOperationId($var)
    {
        GPBUtil::checkString($var, True);
        $this->client_operation_id = $var;

        return $this;
    }

    /**
     * [Deprecated] This field is deprecated.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return $this->creation_timestamp;
    }

    /**
     * [Deprecated] This field is deprecated.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * [Output Only] A textual description of the operation, which is set when the operation is created.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * [Output Only] A textual description of the operation, which is set when the operation is created.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * [Output Only] The time that this operation was completed. This value is in RFC3339 text format.
     *
     * Generated from protobuf field <code>string end_time = 114938801;</code>
     * @return string
     */
    public function getEndTime()
    {
        return $this->end_time;
    }

    /**
     * [Output Only] The time that this operation was completed. This value is in RFC3339 text format.
     *
     * Generated from protobuf field <code>string end_time = 114938801;</code>
     * @param string $var
     * @return $this
     */
    public function setEndTime($var)
    {
        GPBUtil::checkString($var, True);
        $this->end_time = $var;

        return $this;
    }

    /**
     * [Output Only] If errors are generated during processing of the operation, this field will be populated.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Error error = 96784904;</code>
     * @return \Google\Cloud\Compute\V1\Error
     */
    public function getError()
    {
        return isset($this->error) ? $this->error : null;
    }

    public function hasError()
    {
        return isset($this->error);
    }

    public function clearError()
    {
        unset($this->error);
    }

    /**
     * [Output Only] If errors are generated during processing of the operation, this field will be populated.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Error error = 96784904;</code>
     * @param \Google\Cloud\Compute\V1\Error $var
     * @return $this
     */
    public function setError($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\Error::class);
        $this->error = $var;

        return $this;
    }

    /**
     * [Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as `NOT FOUND`.
     *
     * Generated from protobuf field <code>string http_error_message = 202521945;</code>
     * @return string
     */
    public function getHttpErrorMessage()
    {
        return $this->http_error_message;
    }

    /**
     * [Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as `NOT FOUND`.
     *
     * Generated from protobuf field <code>string http_error_message = 202521945;</code>
     * @param string $var
     * @return $this
     */
    public function setHttpErrorMessage($var)
    {
        GPBUtil::checkString($var, True);
        $this->http_error_message = $var;

        return $this;
    }

    /**
     * [Output Only] If the operation fails, this field contains the HTTP error status code that was returned. For example, a `404` means the resource was not found.
     *
     * Generated from protobuf field <code>int32 http_error_status_code = 43909740;</code>
     * @return int
     */
    public function getHttpErrorStatusCode()
    {
        return $this->http_error_status_code;
    }

    /**
     * [Output Only] If the operation fails, this field contains the HTTP error status code that was returned. For example, a `404` means the resource was not found.
     *
     * Generated from protobuf field <code>int32 http_error_status_code = 43909740;</code>
     * @param int $var
     * @return $this
     */
    public function setHttpErrorStatusCode($var)
    {
        GPBUtil::checkInt32($var);
        $this->http_error_status_code = $var;

        return $this;
    }

    /**
     * [Output Only] The unique identifier for the operation. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * [Output Only] The unique identifier for the operation. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * [Output Only] The time that this operation was requested. This value is in RFC3339 text format.
     *
     * Generated from protobuf field <code>string insert_time = 165287059;</code>
     * @return string
     */
    public function getInsertTime()
    {
        return $this->insert_time;
    }

    /**
     * [Output Only] The time that this operation was requested. This value is in RFC3339 text format.
     *
     * Generated from protobuf field <code>string insert_time = 165287059;</code>
     * @param string $var
     * @return $this
     */
    public function setInsertTime($var)
    {
        GPBUtil::checkString($var, True);
        $this->insert_time = $var;

        return $this;
    }

    /**
     * [Output Only] Type of the resource. Always `compute#operation` for Operation resources.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * [Output Only] Type of the resource. Always `compute#operation` for Operation resources.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * [Output Only] Name of the operation.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * [Output Only] Name of the operation.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * [Output Only] The type of operation, such as `insert`, `update`, or `delete`, and so on.
     *
     * Generated from protobuf field <code>string operation_type = 177650450;</code>
     * @return string
     */
    public function getOperationType()
    {
        return $this->operation_type;
    }

    /**
     * [Output Only] The type of operation, such as `insert`, `update`, or `delete`, and so on.
     *
     * Generated from protobuf field <code>string operation_type = 177650450;</code>
     * @param string $var
     * @return $this
     */
    public function setOperationType($var)
    {
        GPBUtil::checkString($var, True);
        $this->operation_type = $var;

        return $this;
    }

    /**
     * [Output Only] An optional progress indicator that ranges from 0 to 100. There is no requirement that this be linear or support any granularity of operations. This should not be used to guess when the operation will be complete. This number should monotonically increase as the operation progresses.
     *
     * Generated from protobuf field <code>int32 progress = 72663597;</code>
     * @return int
     */
    public function getProgress()
    {
        return $this->progress;
    }

    /**
     * [Output Only] An optional progress indicator that ranges from 0 to 100. There is no requirement that this be linear or support any granularity of operations. This should not be used to guess when the operation will be complete. This number should monotonically increase as the operation progresses.
     *
     * Generated from protobuf field <code>int32 progress = 72663597;</code>
     * @param int $var
     * @return $this
     */
    public function setProgress($var)
    {
        GPBUtil::checkInt32($var);
        $this->progress = $var;

        return $this;
    }

    /**
     * [Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     * @return string
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * [Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     * @param string $var
     * @return $this
     */
    public function setRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->region = $var;

        return $this;
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return $this->self_link;
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * [Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.
     *
     * Generated from protobuf field <code>string start_time = 37467274;</code>
     * @return string
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    /**
     * [Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.
     *
     * Generated from protobuf field <code>string start_time = 37467274;</code>
     * @param string $var
     * @return $this
     */
    public function setStartTime($var)
    {
        GPBUtil::checkString($var, True);
        $this->start_time = $var;

        return $this;
    }

    /**
     * [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Operation.Status status = 181260274;</code>
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Operation.Status status = 181260274;</code>
     * @param int $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\Operation\Status::class);
        $this->status = $var;

        return $this;
    }

    /**
     * [Output Only] An optional textual description of the current status of the operation.
     *
     * Generated from protobuf field <code>string status_message = 28992698;</code>
     * @return string
     */
    public function getStatusMessage()
    {
        return $this->status_message;
    }

    /**
     * [Output Only] An optional textual description of the current status of the operation.
     *
     * Generated from protobuf field <code>string status_message = 28992698;</code>
     * @param string $var
     * @return $this
     */
    public function setStatusMessage($var)
    {
        GPBUtil::checkString($var, True);
        $this->status_message = $var;

        return $this;
    }

    /**
     * [Output Only] The unique target ID, which identifies a specific incarnation of the target resource.
     *
     * Generated from protobuf field <code>string target_id = 258165385;</code>
     * @return string
     */
    public function getTargetId()
    {
        return $this->target_id;
    }

    /**
     * [Output Only] The unique target ID, which identifies a specific incarnation of the target resource.
     *
     * Generated from protobuf field <code>string target_id = 258165385;</code>
     * @param string $var
     * @return $this
     */
    public function setTargetId($var)
    {
        GPBUtil::checkString($var, True);
        $this->target_id = $var;

        return $this;
    }

    /**
     * [Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the persistent disk that the snapshot was created from.
     *
     * Generated from protobuf field <code>string target_link = 62671336;</code>
     * @return string
     */
    public function getTargetLink()
    {
        return $this->target_link;
    }

    /**
     * [Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the persistent disk that the snapshot was created from.
     *
     * Generated from protobuf field <code>string target_link = 62671336;</code>
     * @param string $var
     * @return $this
     */
    public function setTargetLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->target_link = $var;

        return $this;
    }

    /**
     * [Output Only] User who requested the operation, for example: `user&#64;example.com`.
     *
     * Generated from protobuf field <code>string user = 3599307;</code>
     * @return string
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * [Output Only] User who requested the operation, for example: `user&#64;example.com`.
     *
     * Generated from protobuf field <code>string user = 3599307;</code>
     * @param string $var
     * @return $this
     */
    public function setUser($var)
    {
        GPBUtil::checkString($var, True);
        $this->user = $var;

        return $this;
    }

    /**
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.Warnings warnings = 229655639;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getWarnings()
    {
        return $this->warnings;
    }

    /**
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.Warnings warnings = 229655639;</code>
     * @param \Google\Cloud\Compute\V1\Warnings[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setWarnings($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\Warnings::class);
        $this->warnings = $arr;

        return $this;
    }

    /**
     * [Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.
     *
     * Generated from protobuf field <code>string zone = 3744684;</code>
     * @return string
     */
    public function getZone()
    {
        return $this->zone;
    }

    /**
     * [Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.
     *
     * Generated from protobuf field <code>string zone = 3744684;</code>
     * @param string $var
     * @return $this
     */
    public function setZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->zone = $var;

        return $this;
    }

}

