<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a Persistent Disk resource.
 * Google Compute Engine has two Disk resources:
 * * [Zonal](/compute/docs/reference/rest/{$api_version}/disks) * [Regional](https://cloud.google.com/compute/docs/reference/rest/{$api_version}/regionDisks)
 * Persistent disks are required for running your VM instances. Create both boot and non-boot (data) persistent disks. For more information, read Persistent Disks. For more storage options, read Storage options.
 * The disks resource represents a zonal persistent disk. For more information, read Zonal persistent disks.
 * The regionDisks resource represents a regional persistent disk. For more information, read  Regional resources. (== resource_for {$api_version}.disks ==) (== resource_for {$api_version}.regionDisks ==)
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.Disk</code>
 */
class Disk extends \Google\Protobuf\Internal\Message
{
    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     */
    private $creation_timestamp = '';
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     */
    private $description = '';
    /**
     * Encrypts the disk using a customer-supplied encryption key.
     * After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later (e.g. to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine).
     * Customer-supplied encryption keys do not protect access to metadata of the disk.
     * If you do not provide an encryption key when creating the disk, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 3225221;</code>
     */
    private $disk_encryption_key = null;
    /**
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    private $guest_os_features;
    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     */
    private $id = '';
    /**
     * [Output Only] Type of the resource. Always compute#disk for disks.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     */
    private $kind = '';
    /**
     * A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
     * To see the latest fingerprint, make a get() request to retrieve a disk.
     *
     * Generated from protobuf field <code>string label_fingerprint = 178124825;</code>
     */
    private $label_fingerprint = '';
    /**
     * Labels to apply to this disk. These can be later modified by the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 231759871;</code>
     */
    private $labels;
    /**
     * [Output Only] Last attach timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string last_attach_timestamp = 42159653;</code>
     */
    private $last_attach_timestamp = '';
    /**
     * [Output Only] Last detach timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string last_detach_timestamp = 56471027;</code>
     */
    private $last_detach_timestamp = '';
    /**
     * Integer license codes indicating which licenses are attached to this disk.
     *
     * Generated from protobuf field <code>repeated string license_codes = 45482664;</code>
     */
    private $license_codes;
    /**
     * A list of publicly visible licenses. Reserved for Google's use.
     *
     * Generated from protobuf field <code>repeated string licenses = 69207122;</code>
     */
    private $licenses;
    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     */
    private $name = '';
    /**
     * Internal use only.
     *
     * Generated from protobuf field <code>string options = 92702366;</code>
     */
    private $options = '';
    /**
     * Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
     *
     * Generated from protobuf field <code>string physical_block_size_bytes = 151572487;</code>
     */
    private $physical_block_size_bytes = '';
    /**
     * [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     */
    private $region = '';
    /**
     * URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
     *
     * Generated from protobuf field <code>repeated string replica_zones = 48438272;</code>
     */
    private $replica_zones;
    /**
     * Resource policies applied to this disk for automatic snapshot creations.
     *
     * Generated from protobuf field <code>repeated string resource_policies = 22220385;</code>
     */
    private $resource_policies;
    /**
     * [Output Only] Server-defined fully-qualified URL for this resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     */
    private $self_link = '';
    /**
     * Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk.
     * If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are 1 to 65536, inclusive.
     *
     * Generated from protobuf field <code>string size_gb = 226493913;</code>
     */
    private $size_gb = '';
    /**
     * The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values:
     * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
     * - projects/project/zones/zone/disks/disk
     * - zones/zone/disks/disk
     *
     * Generated from protobuf field <code>string source_disk = 183318337;</code>
     */
    private $source_disk = '';
    /**
     * [Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
     *
     * Generated from protobuf field <code>string source_disk_id = 185755353;</code>
     */
    private $source_disk_id = '';
    /**
     * The source image used to create this disk. If the source image is deleted, this field will not be set.
     * To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image:
     * projects/debian-cloud/global/images/family/debian-9
     * Alternatively, use a specific version of a public operating system image:
     * projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
     * To create a disk with a custom image that you created, specify the image name in the following format:
     * global/images/my-custom-image
     * You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name:
     * global/images/family/my-image-family
     *
     * Generated from protobuf field <code>string source_image = 50443319;</code>
     */
    private $source_image = '';
    /**
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 113068203;</code>
     */
    private $source_image_encryption_key = null;
    /**
     * [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
     *
     * Generated from protobuf field <code>string source_image_id = 55328291;</code>
     */
    private $source_image_id = '';
    /**
     * The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values:
     * - https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot
     * - projects/project/global/snapshots/snapshot
     * - global/snapshots/snapshot
     *
     * Generated from protobuf field <code>string source_snapshot = 126061928;</code>
     */
    private $source_snapshot = '';
    /**
     * The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 35243866;</code>
     */
    private $source_snapshot_encryption_key = null;
    /**
     * [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
     *
     * Generated from protobuf field <code>string source_snapshot_id = 98962258;</code>
     */
    private $source_snapshot_id = '';
    /**
     * [Output Only] The status of disk creation. CREATING: Disk is provisioning. RESTORING: Source data is being copied into the disk. FAILED: Disk creation failed. READY: Disk is ready for use. DELETING: Disk is deleting.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Disk.Status status = 181260274;</code>
     */
    private $status = 0;
    /**
     * URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project/zones/zone/diskTypes/pd-standard  or pd-ssd
     *
     * Generated from protobuf field <code>string type = 3575610;</code>
     */
    private $type = '';
    /**
     * [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
     *
     * Generated from protobuf field <code>repeated string users = 111578632;</code>
     */
    private $users;
    /**
     * [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string zone = 3744684;</code>
     */
    private $zone = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $creation_timestamp
     *           [Output Only] Creation timestamp in RFC3339 text format.
     *     @type string $description
     *           An optional description of this resource. Provide this property when you create the resource.
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $disk_encryption_key
     *           Encrypts the disk using a customer-supplied encryption key.
     *           After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later (e.g. to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine).
     *           Customer-supplied encryption keys do not protect access to metadata of the disk.
     *           If you do not provide an encryption key when creating the disk, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later.
     *     @type \Google\Cloud\Compute\V1\GuestOsFeature[]|\Google\Protobuf\Internal\RepeatedField $guest_os_features
     *           A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
     *     @type string $id
     *           [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *     @type string $kind
     *           [Output Only] Type of the resource. Always compute#disk for disks.
     *     @type string $label_fingerprint
     *           A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
     *           To see the latest fingerprint, make a get() request to retrieve a disk.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels to apply to this disk. These can be later modified by the setLabels method.
     *     @type string $last_attach_timestamp
     *           [Output Only] Last attach timestamp in RFC3339 text format.
     *     @type string $last_detach_timestamp
     *           [Output Only] Last detach timestamp in RFC3339 text format.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $license_codes
     *           Integer license codes indicating which licenses are attached to this disk.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $licenses
     *           A list of publicly visible licenses. Reserved for Google's use.
     *     @type string $name
     *           Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *     @type string $options
     *           Internal use only.
     *     @type string $physical_block_size_bytes
     *           Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
     *     @type string $region
     *           [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $replica_zones
     *           URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $resource_policies
     *           Resource policies applied to this disk for automatic snapshot creations.
     *     @type string $self_link
     *           [Output Only] Server-defined fully-qualified URL for this resource.
     *     @type string $size_gb
     *           Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk.
     *           If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are 1 to 65536, inclusive.
     *     @type string $source_disk
     *           The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values:
     *           - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
     *           - projects/project/zones/zone/disks/disk
     *           - zones/zone/disks/disk
     *     @type string $source_disk_id
     *           [Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
     *     @type string $source_image
     *           The source image used to create this disk. If the source image is deleted, this field will not be set.
     *           To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image:
     *           projects/debian-cloud/global/images/family/debian-9
     *           Alternatively, use a specific version of a public operating system image:
     *           projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
     *           To create a disk with a custom image that you created, specify the image name in the following format:
     *           global/images/my-custom-image
     *           You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name:
     *           global/images/family/my-image-family
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $source_image_encryption_key
     *           The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
     *     @type string $source_image_id
     *           [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
     *     @type string $source_snapshot
     *           The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values:
     *           - https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot
     *           - projects/project/global/snapshots/snapshot
     *           - global/snapshots/snapshot
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $source_snapshot_encryption_key
     *           The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
     *     @type string $source_snapshot_id
     *           [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
     *     @type int $status
     *           [Output Only] The status of disk creation. CREATING: Disk is provisioning. RESTORING: Source data is being copied into the disk. FAILED: Disk creation failed. READY: Disk is ready for use. DELETING: Disk is deleting.
     *     @type string $type
     *           URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project/zones/zone/diskTypes/pd-standard  or pd-ssd
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $users
     *           [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
     *     @type string $zone
     *           [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return $this->creation_timestamp;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Encrypts the disk using a customer-supplied encryption key.
     * After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later (e.g. to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine).
     * Customer-supplied encryption keys do not protect access to metadata of the disk.
     * If you do not provide an encryption key when creating the disk, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 3225221;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey
     */
    public function getDiskEncryptionKey()
    {
        return isset($this->disk_encryption_key) ? $this->disk_encryption_key : null;
    }

    public function hasDiskEncryptionKey()
    {
        return isset($this->disk_encryption_key);
    }

    public function clearDiskEncryptionKey()
    {
        unset($this->disk_encryption_key);
    }

    /**
     * Encrypts the disk using a customer-supplied encryption key.
     * After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later (e.g. to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine).
     * Customer-supplied encryption keys do not protect access to metadata of the disk.
     * If you do not provide an encryption key when creating the disk, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 3225221;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setDiskEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->disk_encryption_key = $var;

        return $this;
    }

    /**
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGuestOsFeatures()
    {
        return $this->guest_os_features;
    }

    /**
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     * @param \Google\Cloud\Compute\V1\GuestOsFeature[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGuestOsFeatures($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\GuestOsFeature::class);
        $this->guest_os_features = $arr;

        return $this;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * [Output Only] Type of the resource. Always compute#disk for disks.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * [Output Only] Type of the resource. Always compute#disk for disks.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
     * To see the latest fingerprint, make a get() request to retrieve a disk.
     *
     * Generated from protobuf field <code>string label_fingerprint = 178124825;</code>
     * @return string
     */
    public function getLabelFingerprint()
    {
        return $this->label_fingerprint;
    }

    /**
     * A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
     * To see the latest fingerprint, make a get() request to retrieve a disk.
     *
     * Generated from protobuf field <code>string label_fingerprint = 178124825;</code>
     * @param string $var
     * @return $this
     */
    public function setLabelFingerprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->label_fingerprint = $var;

        return $this;
    }

    /**
     * Labels to apply to this disk. These can be later modified by the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 231759871;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels to apply to this disk. These can be later modified by the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 231759871;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * [Output Only] Last attach timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string last_attach_timestamp = 42159653;</code>
     * @return string
     */
    public function getLastAttachTimestamp()
    {
        return $this->last_attach_timestamp;
    }

    /**
     * [Output Only] Last attach timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string last_attach_timestamp = 42159653;</code>
     * @param string $var
     * @return $this
     */
    public function setLastAttachTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_attach_timestamp = $var;

        return $this;
    }

    /**
     * [Output Only] Last detach timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string last_detach_timestamp = 56471027;</code>
     * @return string
     */
    public function getLastDetachTimestamp()
    {
        return $this->last_detach_timestamp;
    }

    /**
     * [Output Only] Last detach timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string last_detach_timestamp = 56471027;</code>
     * @param string $var
     * @return $this
     */
    public function setLastDetachTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_detach_timestamp = $var;

        return $this;
    }

    /**
     * Integer license codes indicating which licenses are attached to this disk.
     *
     * Generated from protobuf field <code>repeated string license_codes = 45482664;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLicenseCodes()
    {
        return $this->license_codes;
    }

    /**
     * Integer license codes indicating which licenses are attached to this disk.
     *
     * Generated from protobuf field <code>repeated string license_codes = 45482664;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLicenseCodes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->license_codes = $arr;

        return $this;
    }

    /**
     * A list of publicly visible licenses. Reserved for Google's use.
     *
     * Generated from protobuf field <code>repeated string licenses = 69207122;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLicenses()
    {
        return $this->licenses;
    }

    /**
     * A list of publicly visible licenses. Reserved for Google's use.
     *
     * Generated from protobuf field <code>repeated string licenses = 69207122;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLicenses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->licenses = $arr;

        return $this;
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Internal use only.
     *
     * Generated from protobuf field <code>string options = 92702366;</code>
     * @return string
     */
    public function getOptions()
    {
        return $this->options;
    }

    /**
     * Internal use only.
     *
     * Generated from protobuf field <code>string options = 92702366;</code>
     * @param string $var
     * @return $this
     */
    public function setOptions($var)
    {
        GPBUtil::checkString($var, True);
        $this->options = $var;

        return $this;
    }

    /**
     * Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
     *
     * Generated from protobuf field <code>string physical_block_size_bytes = 151572487;</code>
     * @return string
     */
    public function getPhysicalBlockSizeBytes()
    {
        return $this->physical_block_size_bytes;
    }

    /**
     * Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
     *
     * Generated from protobuf field <code>string physical_block_size_bytes = 151572487;</code>
     * @param string $var
     * @return $this
     */
    public function setPhysicalBlockSizeBytes($var)
    {
        GPBUtil::checkString($var, True);
        $this->physical_block_size_bytes = $var;

        return $this;
    }

    /**
     * [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     * @return string
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     * @param string $var
     * @return $this
     */
    public function setRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->region = $var;

        return $this;
    }

    /**
     * URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
     *
     * Generated from protobuf field <code>repeated string replica_zones = 48438272;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReplicaZones()
    {
        return $this->replica_zones;
    }

    /**
     * URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
     *
     * Generated from protobuf field <code>repeated string replica_zones = 48438272;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReplicaZones($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->replica_zones = $arr;

        return $this;
    }

    /**
     * Resource policies applied to this disk for automatic snapshot creations.
     *
     * Generated from protobuf field <code>repeated string resource_policies = 22220385;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResourcePolicies()
    {
        return $this->resource_policies;
    }

    /**
     * Resource policies applied to this disk for automatic snapshot creations.
     *
     * Generated from protobuf field <code>repeated string resource_policies = 22220385;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResourcePolicies($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->resource_policies = $arr;

        return $this;
    }

    /**
     * [Output Only] Server-defined fully-qualified URL for this resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return $this->self_link;
    }

    /**
     * [Output Only] Server-defined fully-qualified URL for this resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk.
     * If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are 1 to 65536, inclusive.
     *
     * Generated from protobuf field <code>string size_gb = 226493913;</code>
     * @return string
     */
    public function getSizeGb()
    {
        return $this->size_gb;
    }

    /**
     * Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk.
     * If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are 1 to 65536, inclusive.
     *
     * Generated from protobuf field <code>string size_gb = 226493913;</code>
     * @param string $var
     * @return $this
     */
    public function setSizeGb($var)
    {
        GPBUtil::checkString($var, True);
        $this->size_gb = $var;

        return $this;
    }

    /**
     * The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values:
     * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
     * - projects/project/zones/zone/disks/disk
     * - zones/zone/disks/disk
     *
     * Generated from protobuf field <code>string source_disk = 183318337;</code>
     * @return string
     */
    public function getSourceDisk()
    {
        return $this->source_disk;
    }

    /**
     * The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values:
     * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
     * - projects/project/zones/zone/disks/disk
     * - zones/zone/disks/disk
     *
     * Generated from protobuf field <code>string source_disk = 183318337;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceDisk($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_disk = $var;

        return $this;
    }

    /**
     * [Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
     *
     * Generated from protobuf field <code>string source_disk_id = 185755353;</code>
     * @return string
     */
    public function getSourceDiskId()
    {
        return $this->source_disk_id;
    }

    /**
     * [Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
     *
     * Generated from protobuf field <code>string source_disk_id = 185755353;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceDiskId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_disk_id = $var;

        return $this;
    }

    /**
     * The source image used to create this disk. If the source image is deleted, this field will not be set.
     * To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image:
     * projects/debian-cloud/global/images/family/debian-9
     * Alternatively, use a specific version of a public operating system image:
     * projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
     * To create a disk with a custom image that you created, specify the image name in the following format:
     * global/images/my-custom-image
     * You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name:
     * global/images/family/my-image-family
     *
     * Generated from protobuf field <code>string source_image = 50443319;</code>
     * @return string
     */
    public function getSourceImage()
    {
        return $this->source_image;
    }

    /**
     * The source image used to create this disk. If the source image is deleted, this field will not be set.
     * To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image:
     * projects/debian-cloud/global/images/family/debian-9
     * Alternatively, use a specific version of a public operating system image:
     * projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
     * To create a disk with a custom image that you created, specify the image name in the following format:
     * global/images/my-custom-image
     * You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name:
     * global/images/family/my-image-family
     *
     * Generated from protobuf field <code>string source_image = 50443319;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceImage($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_image = $var;

        return $this;
    }

    /**
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 113068203;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey
     */
    public function getSourceImageEncryptionKey()
    {
        return isset($this->source_image_encryption_key) ? $this->source_image_encryption_key : null;
    }

    public function hasSourceImageEncryptionKey()
    {
        return isset($this->source_image_encryption_key);
    }

    public function clearSourceImageEncryptionKey()
    {
        unset($this->source_image_encryption_key);
    }

    /**
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 113068203;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setSourceImageEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->source_image_encryption_key = $var;

        return $this;
    }

    /**
     * [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
     *
     * Generated from protobuf field <code>string source_image_id = 55328291;</code>
     * @return string
     */
    public function getSourceImageId()
    {
        return $this->source_image_id;
    }

    /**
     * [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
     *
     * Generated from protobuf field <code>string source_image_id = 55328291;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceImageId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_image_id = $var;

        return $this;
    }

    /**
     * The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values:
     * - https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot
     * - projects/project/global/snapshots/snapshot
     * - global/snapshots/snapshot
     *
     * Generated from protobuf field <code>string source_snapshot = 126061928;</code>
     * @return string
     */
    public function getSourceSnapshot()
    {
        return $this->source_snapshot;
    }

    /**
     * The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values:
     * - https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot
     * - projects/project/global/snapshots/snapshot
     * - global/snapshots/snapshot
     *
     * Generated from protobuf field <code>string source_snapshot = 126061928;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceSnapshot($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_snapshot = $var;

        return $this;
    }

    /**
     * The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 35243866;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey
     */
    public function getSourceSnapshotEncryptionKey()
    {
        return isset($this->source_snapshot_encryption_key) ? $this->source_snapshot_encryption_key : null;
    }

    public function hasSourceSnapshotEncryptionKey()
    {
        return isset($this->source_snapshot_encryption_key);
    }

    public function clearSourceSnapshotEncryptionKey()
    {
        unset($this->source_snapshot_encryption_key);
    }

    /**
     * The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 35243866;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setSourceSnapshotEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->source_snapshot_encryption_key = $var;

        return $this;
    }

    /**
     * [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
     *
     * Generated from protobuf field <code>string source_snapshot_id = 98962258;</code>
     * @return string
     */
    public function getSourceSnapshotId()
    {
        return $this->source_snapshot_id;
    }

    /**
     * [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
     *
     * Generated from protobuf field <code>string source_snapshot_id = 98962258;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceSnapshotId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_snapshot_id = $var;

        return $this;
    }

    /**
     * [Output Only] The status of disk creation. CREATING: Disk is provisioning. RESTORING: Source data is being copied into the disk. FAILED: Disk creation failed. READY: Disk is ready for use. DELETING: Disk is deleting.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Disk.Status status = 181260274;</code>
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * [Output Only] The status of disk creation. CREATING: Disk is provisioning. RESTORING: Source data is being copied into the disk. FAILED: Disk creation failed. READY: Disk is ready for use. DELETING: Disk is deleting.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Disk.Status status = 181260274;</code>
     * @param int $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\Disk\Status::class);
        $this->status = $var;

        return $this;
    }

    /**
     * URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project/zones/zone/diskTypes/pd-standard  or pd-ssd
     *
     * Generated from protobuf field <code>string type = 3575610;</code>
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project/zones/zone/diskTypes/pd-standard  or pd-ssd
     *
     * Generated from protobuf field <code>string type = 3575610;</code>
     * @param string $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkString($var, True);
        $this->type = $var;

        return $this;
    }

    /**
     * [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
     *
     * Generated from protobuf field <code>repeated string users = 111578632;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getUsers()
    {
        return $this->users;
    }

    /**
     * [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
     *
     * Generated from protobuf field <code>repeated string users = 111578632;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setUsers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->users = $arr;

        return $this;
    }

    /**
     * [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string zone = 3744684;</code>
     * @return string
     */
    public function getZone()
    {
        return $this->zone;
    }

    /**
     * [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string zone = 3744684;</code>
     * @param string $var
     * @return $this
     */
    public function setZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->zone = $var;

        return $this;
    }

}

